% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intDAG.R
\name{intDAG}
\alias{intDAG}
\title{A DAG function for interventional data}
\usage{
intDAG(X, p, lambda, lambda2, tau = 0.05, rho = 1, A_NZ0 = NULL,
  A0 = NULL, sigma = NULL, Sig = NULL, variance.constraint = TRUE,
  opts.tol = 0.001, maxIter = 1000)
}
\arguments{
\item{X}{The n by M data matrix}

\item{p}{The dimension of the adjacency matrix}

\item{lambda}{tuning parameter for the first penalty of the adjacency matrix}

\item{lambda2}{tuning parameter for the sparsity penalty of the intervention matrix}

\item{tau}{tuning parameter of the TLP function, default is 0.05}

\item{rho}{the ADMM penalty parameter, default is 1}

\item{A_NZ0}{An p by M matrix indicating nonzero elements as initial values}

\item{A0}{An p by M matrix as initial values for (A, B)}

\item{sigma}{the parameter in the variance constraint, not needed when variance.constraint is set to FALSE}

\item{Sig}{vector of length p, the error variances of each node, not needed when variance.constraint is set to FALSE}

\item{variance.constraint}{a flag indicating if the variance constraint is included, default is TRUE}

\item{opts.tol}{Tolerance for convergence}

\item{maxIter}{maximum number of iterations in ADMM loop}
}
\value{
A list with components
  \item{A}{Estimated adjacency matrix}
  \item{B}{Estimated intervention matrix}
  \item{Sig}{Estimated vector of error variances of each node}
  \item{sigma}{Estimated paramter in the variance constraint}
}
\description{
This function allows you to learn the DAG structure from interventional data
}
\examples{
\donttest{p <- w <- 10
s0 <- p # number of edges
lower <- rep(0, (p*(p-1)/2)) # num of possible edges
nz_set <- sample(1:(p*(p-1)/2), s0) # sample a non-zero edge set
lower[nz_set] <- 0.5
amat <- matrix(0, p, p)
amat[lower.tri(amat)] <- lower
bmat <- diag(sqrt(seq(1, 1.5, length=p)))
Sig <- seq(1.5, 1, length = p)
X <- rmvDAG_int(100, amat, bmat, Sig)
Sig0 <- rep(1, p)
sigma0 <- 3
out <- intDAG(X, p, 2, 2, 0.05, rho=10, sigma=sigma0, Sig=Sig0)}
}
