% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosBackground}
\alias{CircosBackground}
\title{Create a BACKGROUND module to be added to a moduleList}
\usage{
CircosBackground(
  modulename,
  compareGroup = 1,
  fillColors = "#EEEEFF",
  borderColors = "#000000",
  axisShow = FALSE,
  axisColor = "#000",
  axisOpacity = 0.5,
  axisNum = 4,
  axisWidth = 0.3,
  maxRadius = 190,
  minRadius = 105,
  borderSize = 0.3,
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{compareGroup}{The group number of this module in compare module}

\item{fillColors}{The color of the background element, in hexadecimal RGB format.}

\item{borderColors}{The color of the background borders, in hexadecimal RGB format.}

\item{axisShow}{Whether show a axis or not}

\item{axisWidth, axisColor, axisOpacity, axisNum}{The color, opacity value and number of line for axis}

\item{minRadius, maxRadius}{Where the module should begin and end}

\item{borderSize}{The thickness of the background borders.}

\item{animationDisplay}{Whether display a animation or not}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{...}{Ignored}
}
\value{
The module tracks for background modules.
}
\description{
Simple background to display behind another module
}
\examples{
Circos(CircosBackground('bg01', fillColors="#FFEEEE", borderSize = 1))

}
