% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarpuy_design.R
\name{tarpuy_design}
\alias{tarpuy_design}
\title{Fieldbook experimental designs}
\usage{
tarpuy_design(
  data,
  nfactors = 1,
  type = "crd",
  rep = 2,
  zigzag = FALSE,
  nrows = NA,
  serie = 100,
  seed = NULL,
  fbname = NA,
  qrcode = "{fbname}{plots}{factors}"
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{nfactors}{Number of factor in the experiment(default = 1). See
details.}

\item{type}{Type of experimental arrange  (default = "crd"). See details.}

\item{rep}{Number of replications in the experiment (default = 3).}

\item{zigzag}{Experiment layout in zigzag [logic: FALSE].}

\item{nrows}{Experimental design dimension by rows [numeric: value]}

\item{serie}{Number to start the plot id [numeric: 100].}

\item{seed}{Replicability of draw results (default = 0) always random. See
details.}

\item{fbname}{Barcode prefix for data collection.}

\item{qrcode}{[string: "\{fbname\}\{plots\}\{factors\}"] String to concatenate the qr code.}
}
\value{
A list with the fieldbook design
}
\description{
Function to deploy experimental designs
}
\details{
The function allows to include the arguments in the sheet that have
  the information of the design. You should include 2 columns in the sheet:
  \code{{arguments}} and \code{{values}}. See examples. The information will
  be extracted automatically and deploy the design. \code{nfactors} = 1:
  crd, rcbd, lsd, lattice. \code{nfactors} = 2 (factorial): split-crd,
  split-rcbd split-lsd \code{nfactors} >= 2 (factorial): crd, rcbd, lsd.
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "1510fOKj0g4CDEAFkrpFbr-zNMnle_Hou9O_wuf7Vdo4/edit?gid=1479851579#gid=1479851579")
# browseURL(url)

fb <- gsheet2tbl(url) 

dsg <- fb \%>\% tarpuy_design() 

dsg \%>\% 
  tarpuy_plotdesign()

}
}
