% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_minmax_normal.R
\name{sim_minmax_normal}
\alias{sim_minmax_normal}
\title{sim_minmax_normal}
\usage{
sim_minmax_normal(
  demand,
  mean,
  sd,
  leadtime,
  service_level,
  Max,
  shortage_cost = FALSE,
  inventory_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.}

\item{sd}{standard deviation in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Max}{Max quantity for order up to level}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Min,max policy or aslo called s,S policy,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. the min is calculated based on a normal distribution.
}
\examples{
sim_minmax_normal(demand = rpois(25,8),mean = 5,sd=1,service_level = 0.5,
leadtime = 4,shortage_cost = 0,Max= 40,inventory_cost = 0)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
