% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_peak.R
\name{get_peak}
\alias{get_peak}
\title{Find the peak of a data series}
\usage{
get_peak(x, y, ties = "median", na.rm = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector of `x` data}

\item{y}{A numeric vector of `y` data}

\item{ties}{As for [stats::approxfun()]: The function to apply to y-values
that have the same x-value. Default `'median'`. `'mean'` may also be
useful.}

\item{na.rm}{As for [stats::approxfun()]: How to handle missing values.
Default `TRUE` to exclude missing values from analysis.}

\item{...}{Optional: Additional arguments which will be passed to
[stats::approx()] (other than `x`, `y`, and `xout`).}
}
\value{
A list with two named numeric scalar components, `x` and `y`,
  containing the x- and y-values at the peak.
}
\description{
Finds x- and y-value at peak y value.
}
\details{
If there is more than one unique `x` value where both `x` and corresponding
`y` are finite, this function calls [stats::approx()] with `method = 'linear'`, then uses
[base::which.max()] to locate the maximum interpolated `y`-value.

If there is only one unique `x` value where both `x` and corresponding `y`
are finite, this function calls [stats::approx()] with `method = 'constant'`, then uses
[base::which.max()] to locate the maximum interpolated `y`-value.

If there are no unique `x` values where both `x` and corresponding `y` are
finite, this function returns `NA_real_` for the peak `x` and `y` values.
}
\author{
Caroline Ring
}
