% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipriorOptim.R
\name{ipriorOptim}
\alias{ipriorOptim}
\title{Estimate an I-prior model using a combination of EM algorithm and direct
optimisation}
\usage{
ipriorOptim(object, control = list(maxit = 3, report = 1))
}
\arguments{
\item{object}{An object of class \code{ipriorKernel}.}

\item{control}{A list of controls for the initial EM algorithm fit. Refer to
\code{\link{iprior}} for a full list of available controls.}
}
\value{
An object of class \code{ipriorMod}.
}
\description{
This is a wrapper function for \code{iprior()} and \code{optim()} which
estimates an I-prior model that has been stored in an \code{ipriorKernel}
object.
}
\details{
The EM algorithm is slow to converge at times, but every iteration is
guaranteed to increase the likelihood value. On the other hand a direct
maximisation of the I-prior likelihood may sometimes result in
ill-conditioned variance parameter due to the nature of the parameterisation
of the I-prior model. Thus, an ideal implementation is a combination of EM
and direct optimisation.

First, the EM algorithm is performed for a maximum of three iterations. This
can be changed by passing a different \code{maxit} value to the list of
control options. The parameters are then passed to \code{optim()} and the
negative log-likelihood is minimised. The method used for optim is
\code{"L-BFGS-B"}, as the \code{psi} parameter of the I-prior model needs to
be contrained to be greater than zero.
}
\examples{
(mod <- kernL(stack.loss ~ ., stackloss))
mod.iprior <- ipriorOptim(mod)
summary(mod.iprior)

}
\seealso{
\code{\link{iprior}} and \code{\link{kernL}}.
}
