% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddi_read.R
\name{ipums_ddi-class}
\alias{ipums_ddi-class}
\alias{ipums_ddi}
\title{\code{ipums_ddi} class}
\description{
The \code{ipums_ddi} class provides a data structure for storing the metadata
information contained in IPUMS codebook files. These objects are primarily
used when loading IPUMS data, but can also be
used to explore metadata for an IPUMS extract.
\itemize{
\item For microdata projects, this information is provided in
\href{https://ddialliance.org/introduction-to-ddi}{DDI codebook}
(.xml) files.
\item For NHGIS, this information is provided in .txt codebook files.
}

The codebook file contains metadata about the extract files themselves,
including file name, file path, and extract date as well as information about
variables present in the data, including variable names, descriptions, data
types, implied decimals, and positions in the fixed-width files.

This information is used to correctly parse IPUMS
fixed-width files and attach additional variable metadata to data upon load.

Note that codebook metadata for NHGIS extracts can also be stored in
an \code{ipums_ddi} object, even though these codebooks are distributed as .txt
files, not .xml files. These files do not adhere to the same standards as
the DDI codebook files, so some \code{ipums_ddi} fields will be left blank when
reading NHGIS codebooks.
\subsection{Creating an \code{ipums_ddi} object}{
\itemize{
\item To create an \code{ipums_ddi} object from an IPUMS microdata extract, use
\code{\link[=read_ipums_ddi]{read_ipums_ddi()}}.
\item To create an \code{ipums_ddi} object from an IPUMS NHGIS extract, use
\code{\link[=read_nhgis_codebook]{read_nhgis_codebook()}}
}
}

\subsection{Loading data}{
\itemize{
\item To load the data associated with an \code{ipums_ddi} object, use
\code{\link[=read_ipums_micro]{read_ipums_micro()}}, \code{\link[=read_ipums_micro_chunked]{read_ipums_micro_chunked()}}, or
\code{\link[=read_ipums_micro_yield]{read_ipums_micro_yield()}}
}
}

\subsection{View metadata}{
\itemize{
\item Use \code{\link[=ipums_var_info]{ipums_var_info()}} to explore variable-level metadata for the variables
included in a dataset.
\item Use \code{\link[=ipums_file_info]{ipums_file_info()}} to explore file-level metadata for an extract.
}
}
}
\keyword{internal}
