% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genENgram.R
\name{genENgram}
\alias{genENgram}
\title{generate SMILES strings from extended N-gram model}
\usage{
genENgram(nsmis, engram, order, gentype = "ML", crange = c(5, 10))
}
\arguments{
\item{nsmis}{is the number of SMILES strings to generate}

\item{engram}{is an ENgram object}

\item{order}{n in the ENgram model}

\item{gentype}{is the type of the procedure used by the SMILES strings generator. For a Back-off procedure, use "ML" (by default),
and for a Neaser-Nay smoothing procedure, use "KN".}

\item{crange}{is the range of lengths, defined in a colum vector, required for the output SMILES strings (from 5 to 10 characters
by default)}
}
\description{
Generate SMILES strings from an extended N-gram model
}
\examples{
\dontrun{data(engram_5k)
smiles <- genENgram(4, engram_5k, 10)
viewstr(smiles)}

}
