% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with_ironseed}
\alias{with_ironseed}
\alias{local_ironseed}
\alias{with_ironseed_stream}
\alias{local_ironseed_stream}
\title{Temporary ironseeds}
\usage{
with_ironseed(seeds, code, quiet = FALSE)

local_ironseed(seeds, ..., quiet = FALSE, .local_envir = parent.frame())

with_ironseed_stream(func, code)

local_ironseed_stream(func, .local_envir = parent.frame())
}
\arguments{
\item{seeds}{An object or list of objects suitable for constructing an
ironseed.}

\item{code}{Code to execute in the temporary environment.}

\item{quiet}{a logical indicating whether to silence messages.}

\item{...}{Additional objects.}

\item{.local_envir}{The environment to use for scoping.}

\item{func}{A stream function returned by \code{ironseed_stream()}}
}
\value{
\code{with_ironseed()} returns the results of the evaluation of the code
argument. \code{local_ironseed()} returns the constructed ironseed.
}
\description{
\code{with_ironseed()} runs code with a specific ironseed and restores global
state afterwards. \code{local_ironseed()} restores global state when the current
evaluation state ends.
}
\seealso{
\link{ironseed} \link{ironseed_stream}
}
