% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IrregularSamplingTimes.R
\name{irregular_multiple_datasets}
\alias{irregular_multiple_datasets}
\title{c/e rates for irregular samplings in multiple datasets}
\usage{
irregular_multiple_datasets(list, vectorlist, c, e, column = NULL, n = NULL,
  CI = FALSE, assembly = F)
}
\arguments{
\item{list}{A list of dataframes.}

\item{vectorlist}{A list of vectors indicating the columns with
presence-absence data.}

\item{c}{Tentative colonization rate.}

\item{e}{Tentative extinction rate.}

\item{column}{The name of the column with groups to calculate their c_e pair.}

\item{n}{Minimal number of rows for each group.}

\item{CI}{Logical. If TRUE, gives the confidence interval of the colonization
and extinction rates.}

\item{assembly}{Logical indicating if the assembly starts from zero species or not.}
}
\value{
A dataframe with colonization and extinction rates and their upper
  and lower confidence interval, and if needed, the names of the groups to
  which colonization and extinction rates have been calculated.
}
\description{
\code{irregular_multiple_datasets} calculates colonization and extinction
rates for data in several datasets.
}
\note{
The columns with the presence-absence data should have the day of that
  sampling on the name of the column in order to calculate colonization and
  extinction.
}
\examples{
irregular_multiple_datasets(simberloff, list(3:17, 3:18, 3:17,
3:19, 3:17, 3:16), 0.001, 0.001)
\dontrun{
irregular_multiple_datasets(simberloff, list(3:17, 3:18, 3:17, 3:19, 3:17,
 3:16), 0.001, 0.001, "Tax. Unit 1", n = 13)
irregular_multiple_datasets(simberloff, list(3:17, 3:18, 3:17, 3:19, 3:17,
 3:16), 0.001, 0.001, "Tax. Unit 1", n = 13, CI = TRUE)
 }
}
\seealso{
\code{\link{regular_sampling_scheme}},
  \code{\link{irregular_single_dataset}}
}

