% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{GTS2020}
\alias{GTS2020}
\title{Oxygen isotope stratigraphy from the Geologic Time Scale 2020: macrofossils}
\format{
A data frame with 9676 rows and 8 variables:
\describe{
\item{age}{Age of the sample expressed as
millions of years before present (Ma).}
\item{d18O_VPDB}{Carbonate d18O value expressed on the VPDB scale (‰).}
\item{d13C_VPDB}{Carbonate d13C value expressed on the VPDB scale (‰).}
\item{mineralogy}{The mineralogy of the carbonate hard part.}
\item{group}{Taxonomic group of the sample
(bivalve, gastropod, belemnite, ammonite).}
\item{clim_zone}{The climate zone the sample represents.}
}
}
\source{
\url{https://download.pangaea.de/dataset/930093/files/GTS2020-App_10.2A.xlsx}
}
\usage{
GTS2020
}
\description{
A dataset containing a compilation of d18O and d13C values
of various macrofossils
(bivalves, gastropods, belemnites, ammonites) together with information
on their age, shell mineralogy, and the climate zone they represent.
This dataset is a condensed version of the entire dataset presented in the
Geologic Time Scale 2020. Specifically, the full dataset was filtered for
those "select" d18O and d13C values that also have age information.
}
\references{
Grossman, E. L., & Joachimski, M. M. (2020).
Oxygen isotope stratigraphy.
In F. M. Gradstein, J. G. Ogg, M. D. Schmitz, & G. M. Ogg (Eds.),
Geologic Time Scale 2020: Volume 1 (pp. 279-307): Elsevier.
\doi{10.1016/B978-0-12-824360-2.00010-3}
}
\seealso{
Other "datasets": 
\code{\link{LR04}},
\code{\link{devilshole}},
\code{\link{meteoric_water}}
}
\concept{"datasets"}
\keyword{datasets}
