test_that("Pairs", {
  skip_if_not_installed("vdiffr")

  ## Compositional data
  coda <- data.frame(
    Na2O = c(14.54, 0.22, 1.46, 0.63, 0.18, 2.48, 2.57, 0.84, 0.85, 0.24, 11.21,
             0.25, 2.73, 14.41, 14.82, 0.65, 1.97, 2.54, 0.17, 13.73),
    CaO = c(6.28, 20.03, 12.28, 17.73, 24.82, 13.01, 14.32, 21.11, 17.95, 25.4,
            7.59, 24.96, 13.24, 8.16, 10.44, 16.63, 19.83, 14.6, 26.36, 8.35),
    K2O = c(3.96, 6.37, 13.91, 12.74, 5.97, 13.56, 9.68, 11.45, 9.83, 4.57, 6.94,
            7.86, 15.08, 2.02, 2.37, 11.61, 6.14, 9.95, 5.57, 4.17),
    MgO = c(2.11, 3.33, 7.44, 3.81, 2.24, 7.81, 6.82, 3.56, 2.9, 2.24, 1.99, 2.78,
            7.33, 1.82, 2.38, 2.97, 4.42, 6.95, 2.28, 3.03),
    P2O5 = c(0.8, NA, 2.62, 3.75, 2.24, NA, NA, 3.84, NA, 2.09, 0.79, NA, 2.12,
             0.71, NA, 1.09, 3.15, NA, NA, 0.19),
    SiO2 = c(70.44, 61.88, 57.61, 56.42, 58.37, 55.87, 57.71, 54.28, 60.35, 61.99,
             63.48, 54.03, 54.79, 66.82, 58.43, 63.13, 57.77, 58.18, 57.74, 66.18),
    Al2O3 = c(0.88, 2.27, 1.07, 1.47, 1.27, 1.11, 1.7, 1.55, 1.63, 2.05, 3.36,
              1.86, 1, 0.4, 1.23, 1.6, 3.58, 1.51, 1.02, 1.37)
  )

  ## Ternary plots with marginal compositions
  pairs_margin <- function() ternary_pairs(coda)
  vdiffr::expect_doppelganger("pairs_margin", pairs_margin)

  ## Ternary plots with MgO
  pairs_column <- function() ternary_pairs(coda, margin = "MgO")
  vdiffr::expect_doppelganger("pairs_column", pairs_column)
})
