% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{founder}
\alias{founder}
\title{Constructor of a Founder Instances of the Specimen Class}
\usage{
founder(specie, code)
}
\arguments{
\item{specie}{an instance of the R6 class Specie with the genome's parameters.}

\item{code}{a length one character vector with one of the genotype codes:
"AA", "Aa", "aA" or "aa".}
}
\value{
Objects of R6 class with methods to mimic in silico Specimens.
}
\description{
Constructor of instances of the Specimen class given the Specie
    from which the individual will belong where all loci will equal to the
    provided genotype.
}
\details{
Genotypes can be coded as \strong{AA}, \strong{Aa}, \strong{aA} or
    \strong{aa}, that meant to represent both homozigous (\strong{AA} and
    \strong{aa}) as well as both heterozigous (\strong{Aa} and \strong{aA}).
}
\examples{
data(ToyMap)
spc <- set_specie(ToyMap)

## through standalone function
AA <- founder(spc, "AA")
aa <- founder(spc, "aa")

## or by the Specie's method
Aa <- spc$founder("Aa")
aA <- spc$founder("aA")

}
