% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_resources_concepts.R
\name{get_structuralresources_concept_schemes_agency}
\alias{get_structuralresources_concept_schemes_agency}
\title{Get concept schemes agency}
\usage{
get_structuralresources_concept_schemes_agency(
  agencyID,
  limit = 25,
  offset = 0,
  query = NULL,
  orderBy = NULL
)
}
\arguments{
\item{agencyID}{(string) Identifier of the agency that publishes.}

\item{limit}{(int) Results limit. By default \code{limit = 25}.}

\item{offset}{(int) Displacement. Result from which it is returned.  By default \code{offset = 0}.}

\item{query}{(string) Query to filter the results.}

\item{orderBy}{(string) Field by which to sort the results.}
}
\description{
This function returns the content from /v1.0/conceptschemes/{agencyID}
}
\examples{
get_structuralresources_concept_schemes_agency("ISTAC")
get_structuralresources_concept_schemes_agency("ESTAT", query = "ID EQ 2090", orderBy = "ID ASC")
}
