% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators-indicators.R
\name{get_indicators}
\alias{get_indicators}
\title{Get indicators}
\usage{
get_indicators(
  q = "",
  order = "",
  limit = 25,
  offset = 0,
  fields = "",
  representation = ""
)
}
\arguments{
\item{q}{(string): Metadata query on which the searches can be built using ``id``, ``subjectCode`` or ``geographicValue``.}

\item{order}{(string): Order. Possible values are: ``update`` and ``id``. Order criteria are ``ASC`` and ``DESC``.}

\item{limit}{(int): Results limit. By default ``limit = 25``.}

\item{offset}{(int): Displacement. Result from which it is returned.  By default ``offset = 0``.}

\item{fields}{(string): Use of the answer by adding new fields. Possible values are: ``+metadata``, ``+data`` and ``+observationsMetadata``.}

\item{representation}{(string): Allows filtering the observations by their value. Its use only makes sense when ``+data`` and/or ``+observationsMetadata`` has been included.}
}
\description{
This function returns a list of indicators published in the ISTAC-indicators database.
An indicator is a measure used to know the intensity of a phenomenon in spacetime. This
measure can refer to different spatial or temporal granularities.
}
\examples{
get_indicators(
q='id IN ("AFILIACIONES", "EMPLEO_REGISTRADO_AGRICULTURA")',
order="id ASC",
fields="+data",
representation="GEOGRAPHICAL[35003|35005], MEASURE[ABSOLUTE]"
)
}
