% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{unvigrep}
\alias{unvigrep}
\title{case-insensitive grep, returning unmatched values}
\usage{
unvigrep(..., ignore.case = TRUE, value = TRUE, invert = TRUE)
}
\arguments{
\item{..., ignore.case, value, invert}{parameters sent to \code{base::grep()}}
}
\value{
vector of non-matching indices
}
\description{
case-insensitive grep, returning unmatched values
}
\details{
This function is a simple wrapper around \code{base::grep()} which
runs in case-insensitive mode, and returns unmatched values.
It is mainly used to save keystrokes,
but is consistently named alongside \code{\link{vgrep}} and
\code{\link{vigrep}}, and quite helpful for writing concise code.
It is particularly useful for removing unwanted entries from a long
vector, for example removing accession numbers from a long
vector of gene symbols in order to review gene annotations.
}
\examples{
V <- paste0(LETTERS[1:5], LETTERS[4:8]);
unigrep("D", V);
igrep("D", V);

}
\seealso{
Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrep}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
