% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{mesh_class}
\alias{mesh_class}
\alias{mesh_80km}
\alias{mesh_10km}
\alias{mesh_1km}
\alias{mesh_500m}
\alias{mesh_250m}
\alias{mesh_125m}
\alias{mesh_100m}
\alias{mesh_auto}
\alias{is_mesh}
\title{Meshcode vector}
\usage{
mesh_80km(x, strict = TRUE)

mesh_10km(x, strict = TRUE)

mesh_1km(x, strict = TRUE)

mesh_500m(x, strict = TRUE)

mesh_250m(x, strict = TRUE)

mesh_125m(x, strict = TRUE)

mesh_100m(x, strict = TRUE)

mesh_auto(x, strict = TRUE)

is_mesh(x)
}
\arguments{
\item{x}{A list or vector.}

\item{strict}{A logical scalar. Should the number of digits in the mesh code match a given number of digits?}
}
\value{
A \code{mesh} class vector.
}
\description{
A series of functions return \code{mesh} class for each mesh size.
\code{mesh_auto} returns automatically determine mesh size by the largest mesh size.
}
\examples{
mesh_80km("53394526313")
mesh_80km("53394526313", strict = FALSE)

mesh_auto(c("53394526313", "5339358633", "533945764"))
mesh_auto(c("53394526313", "5339358633", "533945764"), strict = FALSE)
}
