% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jfa_methods.R
\name{jfa-methods}
\alias{jfa-methods}
\alias{print.jfaPrior}
\alias{print.jfaPosterior}
\alias{print.jfaPlanning}
\alias{print.jfaSelection}
\alias{print.jfaEvaluation}
\alias{print.summary.jfaPrior}
\alias{print.summary.jfaPosterior}
\alias{print.summary.jfaPlanning}
\alias{print.summary.jfaSelection}
\alias{print.summary.jfaEvaluation}
\alias{summary.jfaPrior}
\alias{summary.jfaPosterior}
\alias{summary.jfaPlanning}
\alias{summary.jfaSelection}
\alias{summary.jfaEvaluation}
\alias{predict.jfaPrior}
\alias{predict.jfaPosterior}
\alias{plot.jfaPrior}
\alias{plot.jfaPosterior}
\alias{plot.jfaPlanning}
\alias{plot.jfaSelection}
\alias{plot.jfaEvaluation}
\title{Methods for jfa objects}
\usage{
\method{print}{jfaPrior}(x, ...)

\method{print}{jfaPosterior}(x, ...)

\method{print}{jfaPlanning}(x, ...)

\method{print}{jfaSelection}(x, ...)

\method{print}{jfaEvaluation}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaPrior}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaPosterior}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaPlanning}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaSelection}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaEvaluation}(x, digits = getOption("digits"), ...)

\method{summary}{jfaPrior}(object, digits = getOption("digits"), ...)

\method{summary}{jfaPosterior}(object, digits = getOption("digits"), ...)

\method{summary}{jfaPlanning}(object, digits = getOption("digits"), ...)

\method{summary}{jfaSelection}(object, digits = getOption("digits"), ...)

\method{summary}{jfaEvaluation}(object, digits = getOption("digits"), ...)

\method{predict}{jfaPrior}(object, n, lim = NULL, cumulative = FALSE, ...)

\method{predict}{jfaPosterior}(object, n, lim = NULL, cumulative = FALSE, ...)

\method{plot}{jfaPrior}(x, xlim = c(0, 1), ...)

\method{plot}{jfaPosterior}(x, xlim = c(0, 1), ...)

\method{plot}{jfaPlanning}(x, xlim = c(0, 1), ...)

\method{plot}{jfaSelection}(x, ...)

\method{plot}{jfaEvaluation}(x, xlim = c(0, 1), ...)
}
\arguments{
\item{...}{further arguments, currently ignored.}

\item{digits}{an integer specifying the number of digits to which output should be rounded. Used in \code{summary}.}

\item{object, x}{an object of class \code{jfaPrior}, \code{jfaPosterior}, \code{jfaPlanning}, \code{jfaSelection}, or \code{jfaEvaluation}.}

\item{n}{used in \code{predict}. Specifies the sample size for which predictions should be made.}

\item{lim}{used in \code{predict}. Limits the number of errors for which predictions should be made.}

\item{cumulative}{used in \code{predict}. Specifies whether cumulative probabilities should be shown.}

\item{xlim}{used in \code{plot}. Specifies the x limits (x1, x2) of the plot.}
}
\value{
The \code{summary} methods return a \code{data.frame} which contains the input and output.

The \code{print} methods simply print and return nothing.
}
\description{
Methods defined for objects returned from the \code{\link{auditPrior}}, \code{\link{planning}}, \code{\link{selection}}, and \code{\link{evaluation}} functions.
}
