% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lrt.R
\name{get_lrt}
\alias{get_lrt}
\title{Computes the likelihood ratio test statistic.}
\usage{
get_lrt(f1, f2, data, stable = TRUE, cov.max = 1e+05)
}
\arguments{
\item{f1}{a two-sided formula of the fitted survival model, without the longitudinal outcome in 
the right side of the formula.}

\item{f2}{a two-sided formula of the fitted survival model, same as \code{f1} but with the longitudinal outcome 
being the first covariate on the right side of the formula.}

\item{data}{a data.frame containing the covariates in both \code{f1} and \code{f2}.}

\item{stable}{a parameter, see also \code{jlctree.control}.}

\item{cov.max}{a parameter, see also \code{jlctree.control}.}
}
\value{
The likelihood ratio test statistic.
}
\description{
Computes the likelihood ratio test statistic. 
 Not to be called directly by the user.
}
\examples{
 data(data_timevar);
 f1 <- Surv(time_L, time_Y, delta)~X3+X4+X5;
 f2 <- Surv(time_L, time_Y, delta)~y+X3+X4+X5;
 get_lrt(f1, f2, data_timevar);

}
\seealso{
\code{\link{get_node_val}}
}
