% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_summ.R
\name{export_summs}
\alias{export_summs}
\title{Export regression summaries to tables}
\usage{
export_summs(..., error_style = c("stderr", "ci", "statistic", "pvalue"),
  error_pos = c("below", "right", "same"), statistics = NULL,
  model.names = NULL, to.word = FALSE, word.file = NULL)
}
\arguments{
\item{...}{At minimum, a regression object(s). See details for more arguments.}

\item{error_style}{Which of standard error, confidence intervals, test
statistics, or p values should be used to express uncertainty of estimates
for regression coefficients? Default: "stderr"}

\item{error_pos}{Where should the error statistic defined in
\code{error_style} be placed relative to the coefficient estimate?
Default: "below"}

\item{statistics}{Which model summary statistics should be included?
See \code{\link[huxtable]{huxreg}} for more on usage. The default
for this function depends on the model type. See details for more on
the defaults by model type.}

\item{model.names}{If you want to give your model(s) names at the top
of each column, provide them here as a character vector.
Otherwise, they will just be labeled by number. Default: NULL}

\item{to.word}{Export the table to a Microsoft Word document?
This functionality relies on the \pkg{ReporteRs} package. Default: FALSE}

\item{word.file}{File name with (optionally) file path to save the Word
file. Ignored if \code{to.word} is FALSE. Default: NULL}
}
\value{
If \code{to.word} is FALSE, a \code{\link[huxtable]{huxtable}}
  object. If \code{to.word} is TRUE, it just writes the table to file and
  returns nothing.
}
\description{
This function allows users to use the features of
  \code{\link{summ}} (e.g., standardization, robust standard errors)
  in the context of shareable HTML, LaTeX, and
  Microsoft Word tables. It relies heavily on \code{\link[huxtable]{huxreg}}
  to do the table formatting. This is particularly useful for putting
  the results of multiple models into a single table.
}
\details{
There are many optional parameters not documented above. Any
  argument that you would want to pass to \code{\link{summ}}, for instance,
  will be used. Of particular interest may be the robust and standardize
  arguments. Note that some \code{summ} arguments may not have any bearing
  on the table output.

  The default model summary statistics reporting follows this logic:

  \itemize{
    \item summ.lm = c(N = "nobs", R2 = "r.squared"),
    \item summ.glm = c(N = "nobs", AIC = "AIC", BIC = "BIC"),
    \item summ.svyglm = c(N = "nobs", R2 = "r.squared"),
    \item summ.merMod = c(N = "nobs", AIC = "AIC", BIC = "BIC")
  }

  You can also pass any argument accepted by the
  \code{\link[huxtable]{huxreg}} function. A few that are likely to be
  oft-used are documented above, but visit \code{huxreg}'s documentation
  for more info.

  For info on converting the \code{\link[huxtable]{huxtable}} object to
  HTML or LaTeX, see \code{huxtable}'s documentation.
}
\examples{

fit1 <- lm(Income ~ Frost, data = as.data.frame(state.x77))
fit2 <- lm(Income ~ Frost + Illiteracy, data = as.data.frame(state.x77))
fit3 <- lm(Income ~ Frost + Illiteracy + Murder, data = as.data.frame(state.x77))

# Export all 3 regressions with "Model #" labels,
# standardized coefficients, and robust standard errors
export_summs(fit1, fit2, fit3, model.names = c("Model 1","Model 2","Model 3"),
             standardize = TRUE, robust = TRUE)

}
\seealso{
\code{\link{summ}}

 \code{\link[huxtable]{huxreg}}

 \code{\link[ReporteRs]{writeDoc}}
}
