% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_mat.R
\name{calculate_mat}
\alias{calculate_mat}
\title{Function to calculate the maximum accurate time}
\usage{
calculate_mat(N = Inf, R = Inf, H_0 = 0.5, C = 1)
}
\arguments{
\item{N}{Population Size}

\item{R}{Number of genetic markers}

\item{H_0}{Frequency of heterozygosity at t = 0}

\item{C}{Mean number of crossovers per meiosis (e.g. size in Morgan of
the chromosome)}
}
\value{
The maximum accurate time
}
\description{
Function that calculates the maximum time after hybridization
after which the number of junctions can still be reliably used to estimate
the onset of hybridization. This is following equation 15 in
Janzen et al. 2018.
}
\examples{
calculate_mat(N = Inf, R = 1000, H_0 = 0.5, C = 1)
}
\keyword{analytic}
\keyword{error}
\keyword{time}
