% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_model.R
\docType{methods}
\name{model}
\alias{model}
\alias{coef,EventDate-method}
\alias{fitted,EventDate-method}
\alias{residuals,EventDate-method}
\alias{sigma,EventDate-method}
\alias{terms,EventDate-method}
\title{Extract Model Results}
\usage{
\S4method{coef}{EventDate}(object, calendar = NULL, ...)

\S4method{fitted}{EventDate}(object, calendar = NULL, ...)

\S4method{residuals}{EventDate}(object, calendar = NULL, ...)

\S4method{sigma}{EventDate}(object, calendar = NULL, ...)

\S4method{terms}{EventDate}(x, ...)
}
\arguments{
\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are
returned.}

\item{...}{Currently not used.}

\item{x, object}{An \code{\linkS4class{EventDate}} object.}
}
\description{
\itemize{
\item \code{coef()} extracts model coefficients (see \code{\link[stats:coef]{stats::coef()}}).
\item \code{fitted()} extracts model fitted values (see \code{\link[stats:fitted.values]{stats::fitted()}}).
\item \code{residuals()} extracts model residuals (see \code{\link[stats:residuals]{stats::residuals()}}).
\item \code{sigma()} extracts the residual standard deviation (see \code{\link[stats:sigma]{stats::sigma()}}).
\item \code{terms()} extracts model terms (see \code{\link[stats:terms]{stats::terms()}}).
}
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Assume that some assemblages are reliably dated (this is NOT a real example)
zuni_dates <- c(
  LZ0569 = 1097, LZ0279 = 1119, CS16 = 1328, LZ0066 = 1111,
  LZ0852 = 1216, LZ1209 = 1251, CS144 = 1262, LZ0563 = 1206,
  LZ0329 = 1076, LZ0005Q = 859, LZ0322 = 1109, LZ0067 = 863,
  LZ0578 = 1180, LZ0227 = 1104, LZ0610 = 1074
)

## Model the event and accumulation date for each assemblage
model <- event(zuni, zuni_dates, rank = 10)
plot(model, select = 1:10, event = TRUE, flip = TRUE)
}
\seealso{
Other mutators: 
\code{\link{data.frame}},
\code{\link{mutators}},
\code{\link{series}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
