% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriation_coerce.R
\docType{methods}
\name{as_seriation}
\alias{as_seriation}
\alias{as_seriation-method}
\alias{as_seriation,CA-method}
\title{Coerce an \R Object to a Seriation Order}
\usage{
as_seriation(object, ...)

\S4method{as_seriation}{CA}(object, margin = c(1, 2), axes = 1)
}
\arguments{
\item{object}{An \R object.}

\item{...}{Currently not used.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows then columns, \code{c(2, 1)} indicates columns
then rows.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA axes to be
used.}
}
\value{
A \code{\linkS4class{PermutationOrder}} object.
}
\description{
Coerce an \R Object to a Seriation Order
}
\seealso{
Other seriation methods: 
\code{\link{assess}()},
\code{\link{order}()},
\code{\link{permute}()},
\code{\link{refine}()},
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
