% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_resample.R
\docType{methods}
\name{resample_event}
\alias{resample_event}
\alias{jackknife,EventDate-method}
\alias{bootstrap,EventDate-method}
\title{Resample Event Dates}
\usage{
\S4method{jackknife}{EventDate}(
  object,
  level = 0.95,
  calendar = get_calendar(),
  progress = getOption("kairos.progress"),
  verbose = getOption("kairos.verbose"),
  ...
)

\S4method{bootstrap}{EventDate}(
  object,
  level = 0.95,
  probs = c(0.05, 0.95),
  n = 1000,
  calendar = get_calendar(),
  progress = getOption("kairos.progress"),
  ...
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventDate}} object (typically returned by \code{\link[=event]{event()}}).}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}

\item{...}{Further arguments to be passed to internal methods.}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in
\eqn{[0,1]}.}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
\itemize{
\item \code{bootstrap()} generate bootstrap estimations of an \link[=event]{event}.
\item \code{jackknife()} generate jackknife estimations of an \link[=event]{event}.
}
}
\details{
If \code{jackknife()} is used, one type/fabric is removed at a
time and all statistics are recalculated. In this way, one can assess
whether certain type/fabric has a substantial influence on the date
estimate.
A three columns \code{data.frame} is returned, giving the results of
the resampling procedure (jackknifing fabrics) for each assemblage (in rows)
with the following columns:
\describe{
\item{\code{mean}}{The jackknife mean (event date).}
\item{\code{lower}}{The lower boundary of the confidence interval.}
\item{\code{upper}}{The upper boundary of the confidence interval.}
}

If \code{bootstrap()} is used, a large number of new bootstrap assemblages is
created, with the same sample size, by resampling each of the original
assemblage with replacement. Then, examination of the bootstrap statistics
makes it possible to pinpoint assemblages that require further
investigation.

A five columns \code{data.frame} is returned, giving the bootstrap
distribution statistics for each replicated assemblage (in rows)
with the following columns:
\describe{
\item{\code{min}}{Minimum value.}
\item{\code{mean}}{Mean value (event date).}
\item{\code{max}}{Maximum value.}
\item{\code{Q5}}{Sample quantile to 0.05 probability.}
\item{\code{Q95}}{Sample quantile to 0.95 probability.}
}
}
\seealso{
Other event date tools: 
\code{\link{density_event}()},
\code{\link{event}()},
\code{\link{model_event}},
\code{\link{plot_event}},
\code{\link{predict_event}()}
}
\author{
N. Frerebeau
}
\concept{event date tools}
