% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjimat.R
\name{kanjimat}
\alias{kanjimat}
\title{Create kanjimat objects}
\usage{
kanjimat(
  kanji,
  family = NULL,
  size = NULL,
  margin = 0,
  antialias = TRUE,
  save = FALSE,
  overwrite = FALSE,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{kanji}{a (vector of) character string(s) containing kanjis.}

\item{family}{the font-family to be used. For details see vignette.}

\item{size}{the sidelength of the (square) bitmap}

\item{margin}{extra margin to around the character. Defaults to 0 which leaves a relatively slim margin.
Can be negative, but risks cutting off parts of the character. Units are relative to size in steps of 1/32.}

\item{antialias}{logical. Shall antialiasing be performed?}

\item{save}{logical or character. If FALSE return the (list of) kanjimat object(s). Otherwise save the result
as an rds file in the working directory (as kmatsave.rds) or under the file path provided.}

\item{overwrite}{logical. If FALSE return an error (before any computations are done) if the designated
file path already exists. Otherwise an existing file is overwritten.}

\item{simplify}{logical. Shall a single kanjimat object be returned (instead a list of one) if \code{kanji}
is a single kanji?}

\item{...}{futher arguments passed to \link[grDevices]{png}. This is for extensibility. The only argument
that may currently be used is \code{type}. Trying to change sizes, units, colors or fonts by this argument
results in an error or an undesirable output.}
}
\value{
A list of objects of class \code{kanjimat} or, if only one kanji was specified and
\code{simplify} is \code{TRUE}, a single objects of class \code{kanjimat}. If \code{save = TRUE},
the same is (saved and) still returned invisibly.
}
\description{
Create a (list of) kanjimat object(s), i.e. bitmap representations of a kanji using a certain font-family
and other typographical parameters.
}
\section{Warning}{

If no font family is provided, the default \strong{Chinese} font WenQuanYi Micro Hei that comes with the package showtext is used.
This means that the characters will typically be recognizable, but quite often look odd as Japanese characters.
We strongly advised that a Japanese font is used as detailed above.
}

\examples{
res <- kanjimat(kanji="\u85e4", size = 128)

}
