% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixtureCalls.R
\name{calcGMMCopyNumber}
\alias{calcGMMCopyNumber}
\title{Call copy number for each cell-chromosome using Gaussian mixture models}
\usage{
calcGMMCopyNumber(
  TapestriExperiment,
  cell.barcodes,
  control.copy.number,
  model.components = 1:5,
  model.priors = NULL,
  ...
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{cell.barcodes}{character, vector of cell barcodes to fit GMM. Usually corresponds to diploid control.}

\item{control.copy.number}{\code{data.frame} with columns \code{arm} and \code{copy.number}, indicating of known copy number of cells in \code{cell.barcodes}.}

\item{model.components}{numeric, vector of copy number GMM components to calculate, default \code{1:5} (for copy number = 1, 2, 3, 4, 5).}

\item{model.priors}{numeric, relative prior probabilities for each GMM component. If \code{NULL} (default), assumes equal priors.}

\item{...}{Additional parameters to be passed to internal functions.}
}
\value{
\code{TapestriExperiment} object with copy number calls based on the calculated GMMs, saved to \code{gmmCopyNumber} slot of \code{smoothedCopyNumberByChr} and \code{smoothedCopyNumberByArm} altExps.
GMM parameters for each \code{feature.id} are saved to the \code{metadata} slot.
}
\description{
Uses control cells to simulate expected smoothed copy number distributions for all chromosomes across each of \code{model.components} (copy number level).
Then uses the distributions to calculate posterior probabilities for each cell-chromosome belonging to each of copy number level.
Each cell-chromosome is assigned the copy number value for which its posterior probability is highest.
This is done for both whole chromosomes and chromosome arms.
}
\examples{
\donttest{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- calcNormCounts(tap.object)
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
tap.object <- calcCopyNumber(tap.object,
  control.copy.number,
  sample.feature = "test.cluster"
)
tap.object <- calcSmoothCopyNumber(tap.object)
tap.object <- calcGMMCopyNumber(tap.object,
  cell.barcodes = colnames(tap.object),
  control.copy.number = control.copy.number,
  model.components = 1:5
)
}
}
\concept{copy number}
