% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_mean_squared_logarithmic_error}
\alias{loss_mean_squared_logarithmic_error}
\title{Computes the mean squared logarithmic error between \code{y_true} and \code{y_pred}.}
\usage{
loss_mean_squared_logarithmic_error(
  y_true,
  y_pred,
  ...,
  reduction = "sum_over_batch_size",
  name = "mean_squared_logarithmic_error",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Ground truth values with shape = \verb{[batch_size, d0, .. dN]}.}

\item{y_pred}{The predicted values with shape = \verb{[batch_size, d0, .. dN]}.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}.
Supported options are \code{"sum"}, \code{"sum_over_batch_size"} or \code{NULL}.}

\item{name}{Optional name for the loss instance.}

\item{dtype}{The dtype of the loss's computations. Defaults to \code{NULL}, which
means using \code{config_floatx()}. \code{config_floatx()} is a
\code{"float32"} unless set to different value
(via \code{config_set_floatx()}). If a \code{keras$DTypePolicy} is
provided, then the \code{compute_dtype} will be utilized.}
}
\value{
Mean squared logarithmic error values with shape = \verb{[batch_size, d0, .. dN-1]}.
}
\description{
Note that \code{y_pred} and \code{y_true} cannot be less or equal to \code{0}. Negative
values and \code{0} values will be replaced with \code{config_epsilon()}
(default to \code{1e-7}).

Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- mean(square(log(y_true + 1) - log(y_pred + 1)))
}\if{html}{\out{</div>}}
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- random_uniform(c(2, 3), 0, 2)
y_pred <- random_uniform(c(2, 3))
loss <- loss_mean_squared_logarithmic_error(y_true, y_pred)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/losses/regression_losses#meansquaredlogarithmicerror-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
