% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_categorical}
\alias{random_categorical}
\title{Draws samples from a categorical distribution.}
\usage{
random_categorical(logits, num_samples, dtype = "int32", seed = NULL)
}
\arguments{
\item{logits}{2-D Tensor with shape (batch_size, num_classes). Each row
should define a categorical distribution with the unnormalized
log-probabilities for all classes.}

\item{num_samples}{Int, the number of independent samples to draw for each
row of the input. This will be the second dimension of the output
tensor's shape.}

\item{dtype}{Optional dtype of the output tensor.}

\item{seed}{Optional R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
By default, the \code{seed} argument is \code{NULL}, and an internal global
\code{\link[=random_seed_generator]{random_seed_generator()}} is used. The \code{seed} argument can be
used to ensure deterministic (repeatable) random number generation.
Note that passing an integer as the \code{seed} value will produce the
same random values for each call. To generate different random
values for repeated calls, an instance of
\code{\link[=random_seed_generator]{random_seed_generator()}} must be provided as the \code{seed} value.

Remark concerning the JAX backend: When tracing functions with the
JAX backend the global \code{\link[=random_seed_generator]{random_seed_generator()}} is not
supported. Therefore, during tracing the default value \code{seed=NULL}
will produce an error, and a \code{seed} argument must be provided.}
}
\value{
A 2-D tensor with (batch_size, num_samples).
}
\description{
This function takes as input \code{logits}, a 2-D input tensor with shape
(batch_size, num_classes). Each row of the input represents a categorical
distribution, with each column index containing the log-probability for a
given class.

The function will output a 2-D tensor with shape (batch_size, num_samples),
where each row contains samples from the corresponding row in \code{logits}.
Each column index contains an independent samples drawn from the input
distribution.
}
\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
