% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thisfile.R
\name{thisfile}
\alias{thisfile}
\alias{thisfile_knit}
\alias{thisfile_rscript}
\alias{thisfile_source}
\title{Determines the path of the currently running script}
\usage{
thisfile()

thisfile_source()

thisfile_rscript()

thisfile_knit()
}
\value{
The path of the currently running script, NULL if it cannot be
  determined.
}
\description{
\R does not store nor export the path of the currently running
  script.  This is an attempt to circumvent this limitation by applying
  heuristics (such as call stack and argument inspection) that work in many
  cases.
}
\details{
This functions currently work only if the script was \code{source}d,
  processed with \code{knitr},
  or run with \code{Rscript} or using the \code{--file} parameter to the
  \code{R} executable.  For code run with \code{Rscript}, the exact value
  of the parameter passed to \code{Rscript} is returned.
}
\examples{
\dontrun{thisfile()}
}
\author{
Kirill Müller, Hadley Wickham, Michael R. Head
}
\references{
\url{http://stackoverflow.com/q/1815606/946850}
}
\seealso{
\link[base]{source}, \link[utils]{Rscript}, \link[base]{getwd}
}

