% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\docType{class}
\name{KinPairSimulation-class}
\alias{KinPairSimulation-class}
\alias{KinPairSimulation}
\alias{show,KinPairSimulation-method}
\alias{initialize,KinPairSimulation-method}
\title{KinPairSimulation Class}
\usage{
\S4method{show}{KinPairSimulation}(object)

\S4method{initialize}{KinPairSimulation}(
  .Object,
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  simtype = NULL,
  kerneltype = NULL,
  kernelshape = NULL,
  posigma = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  customsigma = NULL,
  cycle = NULL,
  simdims = NULL,
  call = NULL,
  filtertype = NULL,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  samplenum = NULL,
  sampledims = NULL,
  model = NULL
)
}
\arguments{
\item{object}{object of class KinPairSimulation}

\item{.Object}{object to be constructed into KinPairSimulation class}

\item{data}{tbl_df. tibble  of simulation values}

\item{kinship}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character - one of 'unknown', 'immature' or 'ovipositional'}

\item{simtype}{character - simulation type}

\item{kerneltype}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{kernelshape}{numeric. - value of kernel shape of simulation (if using kernel with shape parameter e.g. vgamma)}

\item{posigma}{numeric - overall value of dispersal sigma (for simple kernel)}

\item{initsigma}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{breedsigma}{numeric.    - value of breeding dispersal sigma (for composite kernel)}

\item{gravsigma}{numeric.    - value of post-breeding dispersal sigma (for composite kernel)}

\item{ovisigma}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{customsigma}{numeric.  - vector of named custom dispersal sigmas (for custom kernel)}

\item{cycle}{integer - number of breeding cycles sampled individual has survived (for custom kernel)}

\item{simdims}{numeric. - dimensions of sampling area (assumes one side of square)}

\item{call}{call. Call to create object}

\item{filtertype}{character. whether the initial sim has been further filtered}

\item{upper}{numeric.       - FILTER: upper threshold used}

\item{lower}{numeric.       - FILTER: lower threshold used}

\item{spacing}{numeric.       - FILTER: spacing used}

\item{samplenum}{numeric.       - FILTER: sample number used}

\item{sampledims}{numeric.       - FILTER: sample dimensions used}

\item{model}{list - model information if custom simulation used to generate object}

\item{KinPairSimulation}{an object of class KinPairSimulation}
}
\value{
returns object of class \code{KinPairSimulation}

No return value, called for side effects

Returns an object of class \code{KinPairSimulation}
}
\description{
The class \code{KinPairSimulation} is a formal (S4) class for storing kinship and dispersal
distribution information derived from simulations in the \code{kindisperse} package.
It is derived from the \code{\link{KinPairData}} class.
The \code{KinPairSimulation} class is used to store information about the spatial distribution of kin dyads for use
in calculating axial sigmas of intergenerational dispersal as initially implemented in Jasper et al. 2019
(\doi{https://doi.org/10.1111/1755-0998.13043}).
}
\details{
This class is essentially wrapped around the \code{tbl_df} class but with (a) expectations around certain columns
that must be present (\code{id1, id2, kinship}, & \code{distance} - three 'character' & one 'numeric' column), as
well as (b) additional attributes (\code{kinship}, \code{lifestage}, & \code{cycle}) characterizing the close-kin
dyads being stored.These attributes, as well as the embedded vector of distances, can be accessed with the methods
\code{\link{kinship}}, \code{\link{lifestage}}, \code{\link{breeding_cycle}} and \code{\link{distances}}.
In addition to the above attributes (derived from the \code{KinPairData} class), this class contains attributes
capturing the simulation type & parameters used to generate the final distribution of kin dyads.

Objects from this class are returned from the \code{\link{simulate_kindist_composite}},
\code{\link{simulate_kindist_simple}} and \code{\link{simulate_kindist_custom}} functions
(& related), and are directly constructed with the namesake \code{KinPairSimulation()} function.
They can be passed to the \code{\link{sample_kindist}} function for filtering and subsampling, and to
axial functions (including \code{\link{axials_standard}} and \code{\link{axpermute_standard}}) for estimation of
axial dispersal.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: print method

\item \code{initialize}: initialisation method
}}

\section{Slots}{

\describe{
\item{\code{kinship}}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{\code{simtype}}{character. - one of 'simple', 'composite' or 'custom'}

\item{\code{kerneltype}}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{\code{posigma}}{numeric.       - overall value of dispersal sigma (for simple kernel)}

\item{\code{initsigma}}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{\code{breedsigma}}{numeric.  - value of breeding dispersal sigma (for composite kernel)}

\item{\code{gravsigma}}{numeric.   - value of post-breeding dispersal sigma (for composite kernel)}

\item{\code{ovisigma}}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{\code{customsigma}}{numeric  - vector of named custom dispersal sigmas (for custom kernel)}

\item{\code{simdims}}{numeric.        - dimensions of sampling area (assumes 1 side of square)}

\item{\code{lifestage}}{character. - lifestage at sampling - either 'immature' or 'ovipositional'}

\item{\code{cycle}}{integer - number of breeding cycles sampled individuals have survived (for custom kernel)}

\item{\code{kernelshape}}{numeric.   - shape parameter if vgamma kerneltype}

\item{\code{call}}{call.           - call to create initial simulation}

\item{\code{tab}}{tbl_df.          - tibble of simulation values}

\item{\code{filtertype}}{character. - whether the initial sim has been further filtered}

\item{\code{upper}}{numeric.       - FILTER: upper threshold used}

\item{\code{lower}}{numeric.       - FILTER: lower threshold used}

\item{\code{spacing}}{numeric.     - FILTER: spacing used}

\item{\code{samplenum}}{numeric.   - FILTER: sample number used}

\item{\code{sampledims}}{numeric.  - FILTER: dimensions used}

\item{\code{model}}{\code{DispersalModel} - model of dispersal used to create object (with custom type)}
}}

\seealso{
Other kdclasses: 
\code{\link{DispersalModel-class}},
\code{\link{KinPairData-class}}
}
\concept{kdclasses}
