#
# Correlated frailty fit to a few families, with 1 covariate
#  Now we have both sexes, and a strata variable.
# The data set is a little too large for frailty.kin, so only
#  keep a subset of the cases, events + 1/2 the others
#
keep <- ((!is.na(cdata$cancer) & cdata$cancer==1) |
	  rep(1:2, length=nrow(cdata)) ==1)
who  <- (!is.na(cdata$parity) & !is.na(cdata$endage) & keep)
#
# Get my kmat by subscripting the large (huge) kmat
temp <- match(cdata$gid[who], dimnames(kmat)[[1]])
options(bdsmatrixsize=prod(dim(kmat)))
tkmat <- 2* kmat[temp,temp]  #kmat's rows are not in the same order as cdata
                             # so tkmat will not be a bdsmatrix
# 
#   The frailty.kin function requires a full kmat, and that matrix
#    must be in gid order to match the coefficients (generated by a
#    factor statement)
#
fit3a <- coxph(Surv(startage, endage, cancer) ~ parity + strata(sex) +
	      frailty.kin(gid, theta=.6, kmat=tkmat), cdata[who,])

#
# Now, create a block-diagonal version of kmat, for the test
#   We leave the missing paritys in, to test that too.
fit3b <- coxme(Surv(startage, endage, cancer) ~ parity+ strata(sex), cdata,
                 random=~1|gid, varlist=kmat, subset=keep,
                 variance=.6)
fit3c <- coxme(Surv(startage, endage, cancer) ~ parity+ strata(sex), cdata,
                 random=~1|gid, varlist=kmat, subset=keep,
                 variance=.6, sparse.calc=0)
aeq(fit3b$imat, fit3c$imat)
# The frailties won't match up:
#  Fit3a is in "gid" order, fit3b in kmat order
# Because fit3b uses sparse computation, we don't get exactly the same
#  answers.  Check it out using a looser criteria than all.equal.
# The indx1 match depends on the fact that gids in cdata are in the same
#  order as in fit3a, that is, in sorted order
indx1 <- match(cdata$gid[who], names(fit3b$frail))
all(abs(fit3a$coef[-1] - fit3b$frail[indx1]) < 1e-3)
all(abs(fit3a$coef[1] - coef(fit3b)$fixed) < 1e-4)
#plot(fit3a$coef[indx1], fit3b$frail)

# Check that the plik is exactly correct
risk <- fit3b$frail[match(cdata$gid, names(fit3b$frail))] +
        coef(fit3b)$fixed * cdata$parity
tfit <- coxph(Surv(startage, endage, cancer) ~ risk + strata(sex), cdata,
              init=1, iter=0, subset=keep)
aeq(fit3b$loglik[3], tfit$loglik[2] - fit3b$pen)
tpen <- sum(fit3b$frail[indx1] * solve(tkmat, fit3b$frail[indx1]))/(2* .6)
aeq(tpen, fit3b$penalty)

# And the integrated likelihood
# The "zeros" matrix is 0 wherever the bds matrix H isn't present
#
temp <- bdsmatrix(blocksize=fit3b$var@blocksize,
                  blocks=rep(1., length(fit3b$var@blocks)))
zeros <- as.matrix(temp)
zeros <- zeros[indx1, indx1]  # rearrange it to tkmat2 order
nn <- fit3a$n
det1 <- sum(log(diag(gchol(tkmat))*0.6))
tfit <- coxph(Surv(startage, endage, cancer) ~ diag(nn) + parity +strata(sex),
              init=c(fit3b$frail[indx1], coef(fit3b)$fixed), iter=0, 
	      data=cdata[who,],
              x=T)
dt <- coxph.detail(tfit)
udt <- apply(dt$score, 2, sum)
upen <- solve(tkmat, fit3b$frail[indx1])/0.6    #first derivative penalty
aeq(udt - c(upen,0), fit3b$u[c(indx1, nn+1)])    #shows that fit3b$u is correct

idt <- matrix(0,nn+1,nn+1)
for (i in 1:length(dt$time)) idt <- idt + dt$imat[,,i]
hmat  <- idt[1:nn, 1:nn] + solve(tkmat*0.6)
ghmat <- gchol(hmat)

det3a <- sum(log(diag(ghmat)))
hmat2 <- hmat* zeros                   # sparse version
det3b <- sum(log(diag(gchol(hmat2))))
det3c <- sum(log(diag(fit3b$hmat)[1:nn]))
all.equal(det3b, det3c)                #should agree
c("Non-sparse log|H|"=det3a, "Sparse log|H|"= det3c)  #of interest

aeq(fit3b$log[2], fit3b$log[3] - 0.5*(det1 + det3b)) #integrated loglik

rm(ghmat, hmat, det1,  det3a, hmat2, det3b, det3c, fit3b)
rm(idt, who, temp, fit3a, indx1, risk, tfit, zeros, tpen)
