% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcabiplot.R
\name{pcabiplot}
\alias{pcabiplot}
\title{Biplot of a PCA object}
\usage{
pcabiplot(PC, x = "PC1", y = "PC2", var.line = TRUE, colobj = rep(1,
  nrow(PC$x)))
}
\arguments{
\item{PC}{A pca object generated by prcomp function.}

\item{x}{X axis.}

\item{y}{Y axis.}

\item{var.line}{A logical input, if variable lines are plotted.}

\item{colobj}{A vector for giving colours to the objects.}
}
\value{
Function returns a pca biplot.
}
\description{
This function create a biplot from a pca object generated by
prcomp function.
}
\details{
This is a function to produce a pca biplot from prcomp
function.
}
\examples{
pcadat <- prcomp(iris[,1:4], scale. = TRUE)
pcabiplot(pcadat)

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
