#' Knowledge spaces on fractions
#'
#' Bases of knowledge spaces on fractions obtained from querying experts.
#'
#' Three experts were queried about prerequisite relationships between 77 items
#' on fractions (Baumunk & Dowling, 1997). A forth basis represents those
#' prerequisite relationships on which the majority of the experts agree
#' (Dowling & Hockemeyer, 1998).
#'
#' @docType data
#'
#' @usage fractions
#'
#' @format A list containing four bases (frac1 to frac3, and fracmaj) in binary
#' matrix form. Each matrix has 77 columns representing the different knowledge
#' items and a varying number of rows containing the basis elements.
#'
#' @references Baumunk, K. & Dowling, C. E. (1997). Validity of spaces for assessing
#' knowledge about fractions. _Journal of Mathematical Psychology, 41,_ 99–105.
#'
#' Dowling, C. E. & Hockemeyer, C. (1998). Computing the intersection of knowledge
#' spaces using only their basis. In Cornelia E. Dowling, Fred S. Roberts, & Peter
#' Theuns, editors, _Recent Progress in Mathematical Psychology,_ pp. 133–141.
#' Lawrence Erlbaum Associates Ltd., Mahwah, NJ.
#'
#' @family Data
"fractions"
