% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateDataSet.R
\name{CreateDataSet}
\alias{CreateDataSet}
\title{Create data set}
\usage{
CreateDataSet(k, n, p, print.plot = TRUE, ClustersLength = NULL)
}
\arguments{
\item{k}{True number of clusters.}

\item{n}{Number of nodes.}

\item{p}{List of probabilities of perturbations (inside and outside clusters).}

\item{print.plot}{TRUE/FALSE indicated whether the graph should be plotted.}

\item{ClustersLength}{Length of the \code{k} clusters (not necessary needed). If not provided, randomly chosen in such a way that \code{sum(ClustersLength)=n}.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{A}}{ Adjacency matrix of the generated graph.}
\item{\code{A_hat}}{ Adjacency matrix of the perturbed version of the generated graph.}
\item{\code{ClustersLength}}{ Length of the \code{k} clusters.}
}
}
\description{
This function generates toy data that can be used to run the l1-spectal clustering algorithm: the adjacency matrix of a graph with \code{n} nodes and its perturbed version.
}
\examples{
 #############################################################
 # Generating toy data
 #############################################################
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.1,p_outside=0.1))

 # Data is a list of three objects:
 # - Data$A is an nxn matrix corresponding to the adjacency matrix of a graph
 # with n nodes and k clusters,
 # - Data$A_hat is a perturbed version of this graph with a probability
 # p_inside of removing an edge inside clusters and
 # p_outside of adding an edge between clusters,
 # - Data$ClustersLength is a vector indicating the length of the clusters.

 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.1,p_outside=0.1), print.plot=TRUE)

 # The same as above but the true graph and its perturbed version are both plotted.
}
\seealso{
\code{\link{l1_spectralclustering}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
