% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lab_atts.R
\name{add_lab_atts}
\alias{add_lab_atts}
\title{Add labelr Attributes from a list to a Data Frame}
\usage{
add_lab_atts(
  data,
  lab.atts.list,
  strip.first = FALSE,
  num.convert = FALSE,
  clean = TRUE
)
}
\arguments{
\item{data}{a data.frame object.}

\item{lab.atts.list}{a list previously created using \code{get_all_lab_atts}.}

\item{strip.first}{FALSE if you do not wish to strip the data.frame of all
label attribute information it may already have (this information may still
be overwritten, depending on what is in the lab.atts.list list).}

\item{num.convert}{attempt to convert to numeric any data.frame variables
where this can be done without producing new NA values.}

\item{clean}{after adding label attributes, put them into a neat, logical
order and drop any attributes that describe variables (columns) not present
in the data.frame to which they have been added.}
}
\value{
a data.frame object with label attribute information (re-) attached
(if it exists in the specified lab.atts.list).
}
\description{
\code{add_lab_atts} allows one to apply a list of labelr label attribute meta-data
(created by \code{get_all_lab_atts}) to a data.frame.
}
\details{
See \code{get_all_lab_atts}.

\code{add_lab_atts} allows one to add or restore label attributes from a free-
standing list (created by \code{get_all_lab_atts}) to a data.frame. Certain
R operations will destroy attributes like labelr labels. Storing label
attributes in an appropriately formatted free-standing list (via
\code{get_all_lab_atts}) beforehand allows one to (re-) associate those attributes
with that data.frame (or associate the attributes with a new data.frame)
using \code{add_lab_atts}.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function

# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

get_val_labs(df, "raceth") # it's here

zlab.df <- get_all_lab_atts(df) # back up labelr attributes for df

df <- strip_labs(df) # this removes labs from df

get_val_labs(df, "raceth") # it's gone

check_any_lab_atts(df) # FALSE (means "no labs here")

df <- add_lab_atts(df, zlab.df) # restore them
}
