% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_ent.R
\name{lsm_l_ent}
\alias{lsm_l_ent}
\alias{lsm_l_ent.RasterLayer}
\alias{lsm_l_ent.RasterStack}
\alias{lsm_l_ent.RasterBrick}
\alias{lsm_l_ent.list}
\title{ENT (landscape level)}
\usage{
lsm_l_ent(landscape, base = "log2")

\method{lsm_l_ent}{RasterLayer}(landscape, base = "log2")

\method{lsm_l_ent}{RasterStack}(landscape, base = "log2")

\method{lsm_l_ent}{RasterBrick}(landscape, base = "log2")

\method{lsm_l_ent}{list}(landscape, base = "log2")
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}
}
\value{
tibble
}
\description{
Shannon entropy
}
\details{
It measures a diversity (thematic complexity) of landscape classes.
}
\examples{
lsm_l_ent(landscape)

}
\references{
Nowosad J., TF Stepinski. 2018. Information-theoretical approach to measure
landscape complexity. https://doi.org/10.1101/383281
}
\seealso{
\code{\link{lsm_l_condent}},
\code{\link{lsm_l_mutinf}},
\code{\link{lsm_l_joinent}},
}
