% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_pr.R
\name{lsm_l_pr}
\alias{lsm_l_pr}
\alias{lsm_l_pr.RasterLayer}
\alias{lsm_l_pr.RasterStack}
\alias{lsm_l_pr.RasterBrick}
\alias{lsm_l_pr.list}
\title{PR (landscape level)}
\usage{
lsm_l_pr(landscape)

\method{lsm_l_pr}{RasterLayer}(landscape)

\method{lsm_l_pr}{RasterStack}(landscape)

\method{lsm_l_pr}{RasterBrick}(landscape)

\method{lsm_l_pr}{list}(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}
}
\value{
tibble
}
\description{
Patch richness (Diversity metric)
}
\details{
\deqn{PR = m}
where \eqn{m} is the number of classes

PR is a 'Diversity metric'. It is one of the simplest diversity and composition measures.
However, because of its absolute nature, it is not comparable among landscapes with
different total areas.

\subsection{Units}{None}
\subsection{Range}{PR >= 1}
\subsection{Behaviour}{Equals PR = 1 when only one patch is present and increases, without
limit, as the number of classes increases}
}
\examples{
lsm_l_pr(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
