% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_correlation.R
\name{calculate_correlation}
\alias{calculate_correlation}
\title{Calculate correlation}
\usage{
calculate_correlation(metrics, method = "pearson", diag = TRUE,
  simplify = FALSE)
}
\arguments{
\item{metrics}{Tibble with results of as returned by the landscapemetrics package.}

\item{method}{Type of correlation. See \code{link{cor}} for details.}

\item{diag}{If FALSE, values on the diagonal will be NA.}

\item{simplify}{If TRUE and only one level is present, only a tibble is returned.}
}
\value{
list
}
\description{
Calculate correlation
}
\details{
The functions calculates the correlation between all metrics. In order to calculate correlations,
for the landscape level more than one landscape needs to be present. All input
must be structured as returned by the \strong{landscapemetrics} package.
}
\examples{
metrics <- calculate_lsm(landscape, what = c("patch", "class"))
calculate_correlation(metrics, method = "pearson")

}
