# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

rcpp_ccl <- function(mat, directions = 8L) {
    invisible(.Call('_landscapemetrics_rcpp_ccl', PACKAGE = 'landscapemetrics', mat, directions))
}

#' Coordinates from a matrix
#'
#' This function gets coordinates (row and column numbers) of the matrix cells.
#'
#' @param x A matrix
#' @param cell A vector of cell number.
#' If NULL, the coordinates will be calculated for the whole matrix
#' @keywords internal
rcpp_xy_from_matrix <- function(x, cell = NULL) {
    .Call('_landscapemetrics_rcpp_xy_from_matrix', PACKAGE = 'landscapemetrics', x, cell)
}

#' Get cell number
#'
#' Get cell number(s) of a matrix from row and column numbers.
#' Cell numbers start at 0 in the upper left corner,
#' and increase from top to bottom, and then from left to right.
#'
#' @param x A matrix
#' @param y A matrix with two columns (row and column numbers)
#' @keywords internal
rcpp_cell_from_xy <- function(x, y) {
    .Call('_landscapemetrics_rcpp_cell_from_xy', PACKAGE = 'landscapemetrics', x, y)
}

#' Create neighborhood coordinates
#'
#' This function creates a neighborhood coordinates matrix based on the directions parameter.
#'
#' @param directions The number of directions in which cells should be connected:
#' 4 (rook's case), 8 (queen's case), or a neighbourhood matrix.
#' The neighbourhood matrix should have one cell with value 0 (the focal cell),
#' and at least one cell with value 1 (the adjacent cells).
#' Cells with other values (e.g. NA) are ignored.
#' @keywords internal
rcpp_create_neighborhood <- function(directions) {
    .Call('_landscapemetrics_rcpp_create_neighborhood', PACKAGE = 'landscapemetrics', directions)
}

rcpp_get_boundaries <- function(xx, directions = 4L) {
    .Call('_landscapemetrics_rcpp_get_boundaries', PACKAGE = 'landscapemetrics', xx, directions)
}

rcpp_get_circle <- function(mat, resolution_xy = 1.0) {
    .Call('_landscapemetrics_rcpp_get_circle', PACKAGE = 'landscapemetrics', mat, resolution_xy)
}

rcpp_get_composition_vector <- function(x) {
    .Call('_landscapemetrics_rcpp_get_composition_vector', PACKAGE = 'landscapemetrics', x)
}

rcpp_get_coocurrence_matrix <- function(x, directions) {
    .Call('_landscapemetrics_rcpp_get_coocurrence_matrix', PACKAGE = 'landscapemetrics', x, directions)
}

rcpp_get_coocurrence_matrix_diag <- function(x, directions) {
    .Call('_landscapemetrics_rcpp_get_coocurrence_matrix_diag', PACKAGE = 'landscapemetrics', x, directions)
}

triangular_index <- function(r, c) {
    .Call('_landscapemetrics_triangular_index', PACKAGE = 'landscapemetrics', r, c)
}

rcpp_get_coocurrence_vector <- function(x, directions, ordered = TRUE) {
    .Call('_landscapemetrics_rcpp_get_coocurrence_vector', PACKAGE = 'landscapemetrics', x, directions, ordered)
}

rcpp_get_entropy <- function(x, base = "log2") {
    .Call('_landscapemetrics_rcpp_get_entropy', PACKAGE = 'landscapemetrics', x, base)
}

#' @title First nearest neighbor distance
#'
#' @description Efficiently calculate the distance to the first nearest neighbor.
#' Quasi linear runtime.
#'
#' @param points A two numeric matrix, where the first two columns are x and y
#'
#' @return Vector
#'
#' @author Florian Privé \email{florian.prive.21@gmail.com}
#'
#' @keywords internal
#'
#' @name rcpp_get_nearest_neighbor
#' @export
rcpp_get_nearest_neighbor <- function(points) {
    .Call('_landscapemetrics_rcpp_get_nearest_neighbor', PACKAGE = 'landscapemetrics', points)
}

rcpp_get_unique_values <- function(x, na_omit = TRUE) {
    .Call('_landscapemetrics_rcpp_get_unique_values', PACKAGE = 'landscapemetrics', x, na_omit)
}

