% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_iji.R
\name{lsm_l_iji}
\alias{lsm_l_iji}
\title{Interspersion and Juxtaposition index (landscape level)}
\usage{
lsm_l_iji(landscape, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Interspersion and Juxtaposition index (Aggregation metric)
}
\details{
\deqn{IJI = \frac{- \sum \limits_{i = 1}^{m} \sum \limits_{k = i + 1}^{m} \Bigg[ \Bigg( \frac{e_{ik}}{E} \Bigg) ln \Bigg( \frac{e_{ik}}{E} \Bigg) \Bigg]}{ln(0.5[m(m - 1)])}  * 100}

where \eqn{e_{ik}} are the unique adjacencies of all classes (lower/upper triangle of
the adjacency table - without the diagonal), \eqn{E} is the total length of edges in the landscape
and \eqn{m} is the number of classes.

IJI is an 'Aggregation metric'. It is a so called "salt and pepper" metric and
describes the intermixing of classes (i.e. without considering like adjacencies - the
diagonal of the adjacency table). The number of classes to calculate IJI must be >= than 3.

\subsection{Units}{Percent}
\subsection{Range}{0 < IJI <= 100}
\subsection{Behaviour}{Approaches 0 if a class is only adjacent to a single other class
and equals 100 when a class is equally adjacent to all other classes.}
}
\examples{
lsm_l_iji(landscape)
}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

McGarigal, K., & Marks, B. J. 1995. FRAGSTATS: spatial pattern analysis
program for quantifying landscape structure. Gen. Tech. Rep. PNW-GTR-351.
Portland, OR: US Department of Agriculture, Forest Service, Pacific Northwest
Research Station. 122 p, 351.
}
\seealso{
\code{\link{lsm_c_iji}}
}
