% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_pd.R
\name{lsm_l_pd}
\alias{lsm_l_pd}
\title{PD (landscape level)}
\usage{
lsm_l_pd(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch density (Aggregation metric)
}
\details{
\deqn{PD = \frac{N} {A} * 10000 * 100}
where \eqn{N} is the number of patches and \eqn{A} is the total landscape
area in square meters.

PD is an 'Aggregation metric'. It describes the fragmentation the landscape, however,
does not necessarily contain information about the configuration or composition of the
landscape. In contrast to \code{\link{lsm_l_np}} it is standardized to the area and
comparisons among landscapes with different total area are possible.

\subsection{Units}{Number per 100 hectares}
\subsection{Ranges}{0 < PD <= 1e+06}
\subsection{Behaviour}{Increases as the landscape gets more patchy. Reaches its maximum
if every cell is a different patch.}
}
\examples{
lsm_l_pd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_c_np}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_c_pd}}
}
