% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_te.R
\name{lsm_c_te}
\alias{lsm_c_te}
\title{TE (class level)}
\usage{
lsm_c_te(landscape, count_boundary = FALSE, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{count_boundary}{Include landscape boundary in edge length}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Total (class) edge (Area and Edge metric)
}
\details{
\deqn{TE = \sum \limits_{k = 1}^{m} e_{ik}}
where \eqn{e_{ik}} is the edge lengths in meters.
TE is an 'Area and edge metric'. Total (class) edge includes all edges between class i and
all other classes k. It measures the configuration of the landscape because a highly
fragmented landscape will have many edges. However, total edge is an absolute measure,
making comparisons among landscapes with different total areas difficult. If
\code{count_boundary = TRUE} also edges to the landscape boundary are included.

\subsection{Units}{Meters}
\subsection{Range}{TE >= 0}
\subsection{Behaviour}{Equals TE = 0 if all cells are edge cells. Increases, without limit,
as landscape becomes more fragmented}
}
\examples{
lsm_c_te(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_p_perim}}
\code{\link{lsm_l_te}}
}
