% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_enn_mn.R
\name{lsm_c_enn_mn}
\alias{lsm_c_enn_mn}
\title{ENN_MN (class level)}
\usage{
lsm_c_enn_mn(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Mean of euclidean nearest-neighbor distance (Aggregation metric)
}
\details{
\deqn{ENN_{MN} = mean(ENN[patch_{ij}])}
where \eqn{ENN[patch_{ij}]} is the euclidean nearest-neighbor distance
of each patch.

ENN_MN is an 'Aggregation metric'. It summarises each class as the mean of each patch
belonging to class i. ENN measures the distance to the  nearest neighbouring patch
of the same class i. The distance is measured from edge-to-edge. The range is limited
by the cell resolution on the lower limit and the landscape extent on the upper limit.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Meters}
\subsection{Range}{ENN_MN > 0}
\subsection{Behaviour}{Approaches ENN_MN = 0 as the distance to the nearest neighbour
decreases, i.e. patches of the same class i are more aggregated. Increases, without limit,
as the distance between neighbouring patches of the same class i increases, i.e. patches are
more isolated.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_enn_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

McGarigal, K., and McComb, W. C. (1995). Relationships between landscape
structure and breeding birds in the Oregon Coast Range.
Ecological monographs, 65(3), 235-260.
}
\seealso{
\code{\link{lsm_p_enn}},
\code{\link[base]{mean}}, \cr
\code{\link{lsm_c_enn_sd}},
\code{\link{lsm_c_enn_cv}}, \cr
\code{\link{lsm_l_enn_mn}},
\code{\link{lsm_l_enn_sd}},
\code{\link{lsm_l_enn_cv}}
}
