\name{birthdeathSim}
\alias{birthdeathSim}

\title{ birthdeathSim }
\description{
  Simulate Branching Times Under the birth-death model and/or with incomplete sampling
}
\usage{
birthdeathSim(b, d, CladeSize, NumberMissing, NumberOfReps)
}

\arguments{
  \item{b}{ the speciation rate }
  \item{d}{ the extinction rate }
  \item{CladeSize}{ the true clade size you wish to simulate }
  \item{NumberMissing}{ the number of taxa missing from the 'real' tree }
  \item{NumberOfReps}{ the number of phylogenies to simulated }
}

\details{
	This generates a matrix of branching times that can be used with 
	\code{fitdAICrc.batch} under any parameterization of a general birth-death
	model with or without incomplete sampling.
	
	To simulate a clade with incomplete sampling, note that \code{CladeSize} is 
	the true size of a phylogeny, and \code{NumberMissing} is the number of missing taxa,
	so if you specified \code{CladeSize = 100} and \code{NumberMissing = 20}, your resulting
	trees would have 80 tips (Trees with 100 tips would be simulated, but then 20 taxa
	would be dropped randomly to simulate incomplete sampling).
	
	THis function is basically a wrapper for the \code{birthdeath.tree} function
	from Geiger, but makes it more amenable to calculation of the delta AIC test
	statistic for detecting temporal changes in diversification rates.
  
}

\value{
  an n x m matrix of branching times, where n is size \code{CladeSize} - \code{NumberMissing}
   and m is size \code{ NumberOfReps }.
}

\author{ Dan Rabosky \email{DLR32@cornell.edu} }


\examples{

}
\keyword{ datagen }
