% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{update.lcModel}
\alias{update.lcModel}
\title{Update a lcModel}
\usage{
\method{update}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{
  Arguments passed on to \code{\link[=latrend]{latrend}}
  \describe{
    \item{\code{method}}{An \code{lcMethod} object specifying the longitudinal cluster method to apply, or the name (as \code{character}) of an \code{lcMethod} subclass. See \linkS4class{lcMethod} for details.}
    \item{\code{data}}{The \code{data.frame} to which to apply the method. Inputs supported by \code{\link[=trajectories]{trajectories()}} can also be used.}
    \item{\code{envir}}{The \code{environment} in which to evaluate the method arguments (by \code{\link[=compose]{compose()}}). This environment is also used to evaluate the \code{data} argument if it is of type \code{call}.}
    \item{\code{verbose}}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
  }}
}
\value{
The refitted \code{lcModel} object, of the same type as the \code{object} argument.
}
\description{
Fit a new model with modified arguments from the current model.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model2 <- latrend(method, latrendData, nClusters = 2)

# fit for a different number of clusters
model3 <- update(model2, nClusters = 3)
}
\seealso{
\link{latrend} \link{getCall}
}
