% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{tsmatrix}
\alias{tsmatrix}
\alias{dcastRepeatedMeasures}
\title{Convert a longitudinal data.frame to a matrix}
\usage{
tsmatrix(
  data,
  response,
  id = getOption("latrend.id"),
  time = getOption("latrend.time"),
  fill = NA
)

dcastRepeatedMeasures(
  data,
  response,
  id = getOption("latrend.id"),
  time = getOption("latrend.time"),
  fill = NA
)
}
\arguments{
\item{data}{The \code{matrix} containing a trajectory on each row.}

\item{response}{The response column name.}

\item{id}{The id column name.}

\item{time}{The time column name.}

\item{fill}{A \code{scalar} value.
If \code{FALSE}, an error is thrown when time series observations are missing in the data frame.
Otherwise, the value used for representing missing observations.}
}
\value{
A \code{matrix} with a trajectory per row.
}
\description{
Converts a longitudinal \code{data.frame} comprising trajectories with an equal number of observations,
measured at identical moments in time, to a \code{matrix}. Each row of the matrix represents a trajectory.
}
\note{
The \code{dcastRepeatedMeasures()} function is deprecated and will be removed in a future version.
Please use \code{tsmatrix()} instead.
}
\seealso{
\link{tsframe}
}
