% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{nIds}
\alias{nIds}
\title{Number of trajectories}
\usage{
nIds(object)
}
\arguments{
\item{object}{The \code{lcModel} object.}
}
\value{
An \code{integer} with the number of trajectories on which the \code{lcModel} was fitted.
}
\description{
Get the number of trajectories (strata) that were used for fitting the given \code{lcModel} object.
The number of trajectories is determined from the number of unique identifiers in the training data. In case the trajectory ids were supplied using a \code{factor} column, the number of trajectories is determined by the number of levels instead.
}
\examples{
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
nIds(model)
}
\seealso{
\link{nobs} \link{nClusters}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
