\name{levelplot}
\title{Level plots and contour plots}
\alias{levelplot}
\alias{contourplot}
\alias{levelplot.formula}
\alias{contourplot.formula}
\alias{levelplot.table}
\alias{contourplot.table}
\alias{levelplot.array}
\alias{contourplot.array}
\alias{levelplot.matrix}
\alias{contourplot.matrix}
\usage{
levelplot(x, data, \dots)
contourplot(x, data, \dots)

\method{levelplot}{formula}(x,
          data,
          allow.multiple = is.null(groups) || outer,
          outer = TRUE,
          aspect = "fill",
          panel = lattice.getOption("panel.levelplot"),
          prepanel = NULL,
          scales = list(),
          strip = TRUE,
          groups = NULL,
          xlab,
          xlim,
          ylab,
          ylim,
          at,
          cuts = 15,
          pretty = FALSE,
          region = TRUE,
          drop.unused.levels = lattice.getOption("drop.unused.levels"),
          \dots,
          lattice.options = NULL,
          default.scales = list(),
          colorkey = region,
          col.regions,
          alpha.regions,
          subset = TRUE)

\method{contourplot}{formula}(x,
            data,
            panel = lattice.getOption("panel.contourplot"),
            cuts = 7,
            labels = TRUE,
            contour = TRUE,
            pretty = TRUE,
            region = FALSE,
            \dots)

\method{levelplot}{table}(x, data = NULL, aspect = "iso", \dots,
          xlim, ylim, row.values, column.values)

\method{contourplot}{table}(x, data = NULL, aspect = "iso", \dots,
            xlim, ylim, row.values, column.values)

\method{levelplot}{matrix}(x, data = NULL, xlab, ylab, \dots)

\method{contourplot}{matrix}(x, data = NULL, xlab, ylab, \dots)

\method{levelplot}{array}(x, data = NULL, \dots)

\method{contourplot}{array}(x, data = NULL, \dots)


}
\description{
  Draw Level Plots and Contour plots.
}
\arguments{
  \item{x}{
    for the \code{formula} method, a formula of the form \code{z ~ x * y
      | g1 * g2 * \dots}, where \code{z} is a numeric response, and
    \code{x}, \code{y} are numeric values evaluated on a rectangular
    grid.  \code{g1, g2, \dots} are optional conditional variables, and
    must be either factors or shingles if present.

    Calculations are based on the assumption that all x and y values are
    evaluated on a grid (defined by their unique values). The function
    will not return an error if this is not true, but the display might
    not be meaningful.  However, the x and y values need not be equally
    spaced.

    Both \code{levelplot} and \code{wireframe} have methods for
    \code{matrix}, \code{array}, and \code{table} objects, in which case
    \code{x} provides the \code{z} vector described above, while its
    rows and columns are interpreted as the \code{x} and \code{y}
    vectors respectively.  This is similar to the form used in
    \code{filled.contour} and \code{image}.  For higher-dimensional
    arrays and tables, further dimensions are used as conditioning
    variables.  Note that the dimnames may be duplicated; this is
    handled by calling \code{\link{make.unique}} to make the names
    unique (although the original labels are used for the x- and
    y-axes).
  }
  \item{data}{
    For the \code{formula} methods, an optional data frame in which
    variables in the formula (as well as \code{groups} and
    \code{subset}, if any) are to be evaluated.  Usually ignored with a
    warning in other cases.
  }
  \item{row.values, column.values}{ Optional vectors of values that
    define the grid when \code{x} is a matrix.  \code{row.values} and
    \code{column.values} must have the same lengths as \code{nrow(x)}
    and \code{ncol(x)} respectively.  By default, row and column
    numbers. }
  \item{panel}{
    panel function used to create the display, as described in
    \code{\link{xyplot}}
  }
  \item{aspect}{
    For the \code{matrix} methods, the default aspect ratio is chosen to
    make each cell square.  The usual default is \code{aspect="fill"},
    as described in \code{\link{xyplot}}.
  }
  \item{at}{
    numeric vector giving breaks along the range of \code{z}. Contours
    (if any) will be drawn at these heights, and the regions in between
    would be colored using \code{col.regions}.
  }
  \item{col.regions}{ color vector to be used if regions is TRUE. The
    general idea is that this should be a color vector of moderately
    large length (longer than the number of regions. By default this is
    100). It is expected that this vector would be gradually varying in
    color (so that nearby colors would be similar). When the colors are
    actually chosen, they are chosen to be equally spaced along this
    vector. When there are more regions than col.regions, the colors are
    recycled.
  }
  \item{alpha.regions}{
    numeric, specifying alpha transparency (works only on some devices)
  }
  \item{colorkey}{logical specifying whether a color key is to be drawn
    alongside the plot, or a list describing the color key. The list may
    contain the following components:

    \describe{
    
      \item{\code{space}:}{
        location of the colorkey, can be one of \code{"left"},
	\code{"right"}, \code{"top"} and \code{"bottom"}.  Defaults to
	\code{"right"}.
      }
      
      \item{\code{x}, \code{y}:}{ location, currently unused }

      \item{\code{col}:}{ vector of colors }
      
      \item{\code{at}:}{
        numeric vector specifying where the colors change. must be of
        length 1 more than the col vector.
      }

      \item{\code{labels}:}{
        a character vector for labelling the \code{at} values, or more
        commonly, a list describing characteristics of the labels.  This
	list may include components \code{labels}, \code{at},
	\code{cex}, \code{col}, \code{rot}, \code{font}, \code{fontface}
	and \code{fontfamily}.
      }

      \item{\code{tick.number}:}{ approximate number of ticks. }

      \item{\code{corner}:}{ interacts with x, y; unimplemented }

      \item{\code{width}:}{ width of the key }

      \item{\code{height}:}{ length of key w.r.t side of plot. }
    }
  }
  \item{contour}{
    logical, whether to draw contour lines.
  }
  \item{cuts}{
    number of levels the range of \code{z} would be divided into
  }
  \item{labels}{
    typically a logical indicating whether contour lines should be
    labelled, but other possibilities for more sophisticated control
    exists.  Details are documented in the help page for
    \code{\link{panel.levelplot}}, to which this argument is passed on
    unchanged.  That help page also documents the \code{label.style}
    argument, which affects how the labels are rendered.
  }
  \item{pretty}{
    logical, whether to use pretty cut locations and labels
  }
  \item{region}{
    logical, whether regions between contour lines should be filled
  }
  \item{allow.multiple, outer, prepanel, scales, strip, groups, xlab,
    xlim, ylab, ylim, drop.unused.levels, lattice.options,
    default.scales, subset}{
    these arguments are described in the help page for
    \code{\link{xyplot}}.
  }
  \item{\dots}{ other arguments.  Some are processed by \code{levelplot}
    or \code{contourplot}, and those unrecognized are passed on to the
    panel function.  }
}
\details{
  These and all other high level Trellis functions have several
  arguments in common. These are extensively documented only in the
  help page for \code{xyplot}, which should be consulted to learn more
  detailed usage.

  Other useful arguments are mentioned in the help page for the default
  panel function \code{\link{panel.levelplot}} (these are formally
  arguments to the panel function, but can be specified in the high
  level calls directly).
}

\references{
  Sarkar, Deepayan (2008) "Lattice: Multivariate Data Visualization with
  R", Springer. \url{http://lmdvr.r-forge.r-project.org/}
}

\value{

  An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.

}
\seealso{
  \code{\link{xyplot}}, \code{\link{Lattice}},
  \code{\link{panel.levelplot}}
}
\author{Deepayan Sarkar \email{Deepayan.Sarkar@R-project.org}}
\examples{
x <- seq(pi/4, 5 * pi, length = 100)
y <- seq(pi/4, 5 * pi, length = 100)
r <- as.vector(sqrt(outer(x^2, y^2, "+")))
grid <- expand.grid(x=x, y=y)
grid$z <- cos(r^2) * exp(-r/(pi^3))
levelplot(z~x*y, grid, cuts = 50, scales=list(log="e"), xlab="",
          ylab="", main="Weird Function", sub="with log scales",
          colorkey = FALSE, region = TRUE)


#S-PLUS example
require(stats)
attach(environmental)
ozo.m <- loess((ozone^(1/3)) ~ wind * temperature * radiation,
       parametric = c("radiation", "wind"), span = 1, degree = 2)
w.marginal <- seq(min(wind), max(wind), length = 50)
t.marginal <- seq(min(temperature), max(temperature), length = 50)
r.marginal <- seq(min(radiation), max(radiation), length = 4)
wtr.marginal <- list(wind = w.marginal, temperature = t.marginal,
        radiation = r.marginal)
grid <- expand.grid(wtr.marginal)
grid[, "fit"] <- c(predict(ozo.m, grid))
contourplot(fit ~ wind * temperature | radiation, data = grid,
            cuts = 10, region = TRUE,
            xlab = "Wind Speed (mph)",
            ylab = "Temperature (F)",
            main = "Cube Root Ozone (cube root ppb)")
detach()
}
\keyword{hplot}



