% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGrid.R
\name{createGrid}
\alias{createGrid}
\title{Create a Mesh for the Integration}
\usage{
createGrid(n, xmin, xmax, d.y, d.z, zmax, fine, double)
}
\arguments{
\item{n}{the number of points for the mesh in the x direction.}

\item{xmin}{the minimal x value.}

\item{xmax}{the maximal x value.}

\item{d.y}{the number of dimensions for the triangle.}

\item{d.z}{the number of dimensions.}

\item{zmax}{the maximal z value (in absolute value).}

\item{fine}{should the mesh be displayed}

\item{double}{should the grid be just outside the region of interest? Otherwise it will be just inside.}
}
\description{
Create a mesh for the integration
}
\details{
This create a mesh for integrating over a triangular surface using rectangles.
The domain is define by constrains on three types of variables:
\itemize{
\item the x variable: [unidimensional] that varies freely between [-xmax,-xmin] U [xmin,xmax].
\item the y variables: [dimension d.y] constrained to be lower in absolute value than the x variable.
In 2D this corresponds to 2 triangles, and in higher dimension to cones/hypercones.
\item the z variables: [dimension d.z] constrained to vary between [-zmax,zmax].
}
The intersection of these three conditions define the domain.

The mesh is obtained slicing the triangles using rectangles.
}
\examples{

## no z 
gridInt_2d <- createGrid(5, d.y = 1, xmin = 0, xmax = 4, 
                         d.z = 0, fine = FALSE, double = FALSE)
gridExt_2d <- createGrid(5, d.y = 1, xmin = 0, xmax = 4, 
                         d.z = 0, fine = FALSE, double = TRUE)

gridInt_4d <- createGrid(5, d.y = 3, xmin = 0, xmax = 4, 
                         d.z = 0, fine = FALSE, double = FALSE)
gridExt_4d <- createGrid(5, d.y = 3, xmin = 0, xmax = 4, 
                         d.z = 0, fine = FALSE, double = TRUE)

gridInt_2d <- createGrid(5, d.y = 1, xmin = 0, xmax = 4, 
                         d.z = 0, fine = TRUE, double = FALSE)

##  z
gridIntZ1_2d <- createGrid(5, d.y = 1, xmin = 0, xmax = 4, 
                           d.z = 1, zmax = 2, fine = FALSE, double = FALSE)
gridExtZ1_2d <- createGrid(5, d.y = 1, xmin = 0, xmax = 4, 
                           d.z = 1, zmax = 2, fine = FALSE, double = TRUE)
 
gridIntZ2_4d <- createGrid(5, d.y = 3, xmin = 0, xmax = 4, 
                           d.z = 2, zmax = 2, fine = FALSE, double = FALSE)
gridExtZ2_4d <- createGrid(5, d.y = 3, xmin = 0, xmax = 4, 
                           d.z = 2, zmax = 2, fine = FALSE, double = TRUE)

}
