% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefType.R
\name{coefType}
\alias{coefType}
\alias{coefType.lvm}
\alias{coefType.lvmfit}
\alias{coefType.multigroup}
\title{Extract the Type of Each Coefficient}
\usage{
coefType(object, ...)

\method{coefType}{lvm}(object, data = NULL, as.lava = TRUE, ...)

\method{coefType}{lvmfit}(object, as.lava = TRUE, ...)

\method{coefType}{multigroup}(object, as.lava = TRUE, ...)
}
\arguments{
\item{object}{a \code{lvm} or \code{lvmfit} object.}

\item{...}{arguments to be passed to \code{lava::coef}}

\item{data}{[data.frame, optional] the dataset. Help to identify the categorical variables.}

\item{as.lava}{[logical] export the type of coefficients mimicking \code{lava:::coef}.}
}
\value{
\code{coefType} returns a \code{data.frame} when \code{as.lava=FALSE}:
\itemize{
\item name: name of the link
\item Y: outcome variable
\item X: regression variable in the design matrix (could be a transformation of the original variables, e.g. dichotomization).
\item data: original variable
\item type: type of link
\item value: if TRUE, the value of the link is set and not estimated.
\item marginal: if TRUE, the value of the link does not impact the estimation.
\item detail: a more detailed description of the type of link (see the details section)
\item lava: name of the coefficient in lava
}
When \code{as.lava=TRUE}, \code{coefType} returns a named vector containing the type of each coefficient.
}
\description{
Extract the type of each coefficient of a \code{lvm} object.
}
\details{
A lvm can be written as a measurement model:
\deqn{Y_i = \nu + \Lambda \eta_i + K X_i + \epsilon_i}
and a structural model:
\deqn{\eta_i = \alpha + B \eta_i + \Gamma X_i + \zeta_i}
where \eqn{\Psi}   is the variance covariance matrix of the residuals \eqn{\zeta} \cr
and   \eqn{\Sigma} is the variance covariance matrix of the residuals \eqn{\epsilon}. \cr \cr

\code{coefType} either returns the Latin/Greek letter corresponding to the coefficients
or it groups them:
\itemize{
\item intercept: \eqn{\nu} and \eqn{\alpha}.
\item regression: \eqn{\Lambda}, \eqn{K}, \eqn{B}, and \eqn{\Gamma}.
\item covariance: extra-diagonal terms of \eqn{\Sigma} and \eqn{\Psi}.
\item variance: diagonal of \eqn{\Sigma} and \eqn{\Psi}.
}

A link denotes a relationship between two variables.
The coefficient are used to represent the strength of the association between two variable, i.e. the strength of a link.
A coefficient may corresponds to the strength of one or several link.
}
\examples{
#### regression ####
m <- lvm(Y~X1+X2)
e <- estimate(m, lava::sim(m, 1e2))

coefType(m)
coefType(e)

#### LVM ####
m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
covariance(m) <- y1~y2

m.Sim <- m
categorical(m.Sim, labels = c("a","b","c")) <- ~x2
e <- estimate(m, lava::sim(m.Sim, 1e2))

coefType(m)
coefType(e)

## additional categorical variables 
categorical(m, labels = as.character(1:3)) <- "X1"

coefType(m, as.lava = FALSE)

#### LVM with constrains ####
m <- lvm(c(Y1~0+1*eta1,Y2~0+1*eta1,Y3~0+1*eta1,
          Z1~0+1*eta2,Z2~0+1*eta2,Z3~0+1*eta2))
latent(m) <- ~eta1 + eta2
e <- estimate(m, lava::sim(m,1e2))

coefType(m)
coefType(e)

#### multigroup ####
m <- lvm(Y~X1+X2)
eG <- estimate(list(m,m), list(lava::sim(m, 1e2), lava::sim(m, 1e2)))
coefType(eG)

}
\concept{
extractor
}
